/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.fsp;

import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.network.FirewallRule;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.impl.disc.fsp.FspCallHomeListener;
import com.ibm.hwmca.fw.fcs.impl.disc.fsp.FspUtil;
import com.ibm.hwmca.fw.rcs.CommManager;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FspFirewallManager {
    private static final String TRACE_MASKD = "XFSPFWMD";
    private static final String TRACE_MASKF = "XFSPFWMF";
    private static final String TRACE_MASKT = "XFSPFWMT";
    private static FspFirewallManager fspFirewallManager;
    private FirewallAdmin firewallAdmin;
    private static Object lock;
    private static Object subnetRulesLock;
    private static boolean callHomeServer;
    private static boolean canCommunicateWithFSP;
    private boolean subnetRulesRegistered = false;
    private Set subnetRules = new HashSet();
    private Set hmcRules = new HashSet();
    private static final String TCP_PORT;
    private static final String UDP_PORT;
    private static final String NO_BITS = "0.0.0.0";
    private static final String ALL_BITS = "255.255.255.255";

    private FspFirewallManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FspFirewallManager getFspFirewallManager() {
        Object object = lock;
        synchronized (object) {
            if (fspFirewallManager == null) {
                fspFirewallManager = new FspFirewallManager();
                FspFirewallManager.fspFirewallManager.firewallAdmin = FirewallAdmin.getFirewallAdmin();
                fspFirewallManager.removeRule(NO_BITS, NO_BITS);
                FcsServer.getFcsServer().addFcsEventListener(new FspCallHomeListener());
                callHomeServer = FcsServer.getFcsServer().getLocalServices().contains(CommManager.FCS_SERVICE_ID);
                boolean bl = canCommunicateWithFSP = FspUtil.listAllManagedCecs().length > 0;
                if (callHomeServer) {
                    fspFirewallManager.addSubnetRules();
                } else if (!canCommunicateWithFSP) {
                    fspFirewallManager.addSubnetRules();
                }
            }
        }
        return fspFirewallManager;
    }

    protected void setCallHomeServer(boolean callHomeServer) {
        Trace.trace(TRACE_MASKT, "<> setCallHomeServer(" + callHomeServer + ")");
        if (callHomeServer != FspFirewallManager.callHomeServer) {
            Trace.trace(TRACE_MASKF, "new state");
            FspFirewallManager.callHomeServer = callHomeServer;
            if (callHomeServer) {
                if (!this.subnetRulesRegistered) {
                    this.addSubnetRules();
                }
            } else if (this.subnetRulesRegistered && canCommunicateWithFSP) {
                this.removeSubnetRules();
            }
        }
    }

    protected void setAvailableAddresses(InetAddress[] iaddrs) {
        String ip;
        Iterator iterator = this.hmcRules.iterator();
        while (iterator.hasNext()) {
            ip = (String)iterator.next();
            boolean found = false;
            for (int i = 0; i < iaddrs.length; ++i) {
                if (iaddrs[i].getHostAddress().equals(ip)) {
                    found = true;
                    i = iaddrs.length;
                }
                if (found) continue;
                iterator.remove();
                this.removeRule(ip, ALL_BITS);
            }
        }
        for (int i = 0; i < iaddrs.length; ++i) {
            ip = iaddrs[i].getHostAddress();
            if (this.hmcRules.contains(ip)) continue;
            this.addRule(ip, ALL_BITS);
            this.hmcRules.add(ip);
        }
    }

    protected void setCanCommunicateWithFSP(boolean canCommunicateWithFSP) {
        Trace.trace(TRACE_MASKT, "<> setCanCommunicateWithFSP(" + canCommunicateWithFSP + ")");
        if (FspFirewallManager.canCommunicateWithFSP != canCommunicateWithFSP) {
            Trace.trace(TRACE_MASKF, "new state");
            FspFirewallManager.canCommunicateWithFSP = canCommunicateWithFSP;
            if (canCommunicateWithFSP) {
                if (!callHomeServer && this.subnetRulesRegistered) {
                    this.removeSubnetRules();
                }
            } else {
                this.addSubnetRules();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubnetRules() {
        Trace.trace(TRACE_MASKT, "<> removeSubnetRules()");
        Object object = subnetRulesLock;
        synchronized (object) {
            Iterator iterator = this.subnetRules.iterator();
            while (iterator.hasNext()) {
                FirewallRule rule = (FirewallRule)iterator.next();
                try {
                    this.firewallAdmin.removeFirewallRule(rule);
                }
                catch (FirewallAdminException fae) {
                    Trace.trace(TRACE_MASKF, "Error removing FCS firewall rules");
                    Trace.trace(TRACE_MASKF, fae);
                }
                iterator.remove();
            }
        }
        this.subnetRulesRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubnetRules() {
        Trace.trace(TRACE_MASKT, "<> addSubnetRules()");
        List networkInterfaceInformation = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo();
        Object object = subnetRulesLock;
        synchronized (object) {
            Iterator iterator = networkInterfaceInformation.iterator();
            while (iterator.hasNext()) {
                NetworkInterfaceInformation nic = (NetworkInterfaceInformation)iterator.next();
                String ip = nic.getIpAddr();
                String subnet = ip.substring(0, ip.lastIndexOf(".")) + ".0";
                FirewallRule rule = null;
                Trace.trace(TRACE_MASKF, "adding subnet rule [" + subnet + "]");
                try {
                    rule = new FirewallRule(nic.getIfname(), subnet, "255.255.255.0", "tcp", TCP_PORT);
                    this.firewallAdmin.addFirewallRule(rule);
                    this.subnetRules.add(rule);
                }
                catch (FirewallAdminException fae) {
                    Trace.trace(TRACE_MASKF, "Error adding FCS firewall rules");
                    Trace.trace(TRACE_MASKF, fae);
                }
                try {
                    rule = new FirewallRule(nic.getIfname(), subnet, "255.255.255.0", "udp", UDP_PORT);
                    this.firewallAdmin.addFirewallRule(rule);
                    this.subnetRules.add(rule);
                }
                catch (FirewallAdminException fae) {
                    Trace.trace(TRACE_MASKF, "Error adding FCS firewall rules");
                    Trace.trace(TRACE_MASKF, fae);
                }
            }
        }
        this.subnetRulesRegistered = true;
    }

    private void removeRule(String sourceAddr, String sourceAddrMask) {
        Trace.trace(TRACE_MASKF, "<> removing FCS firewall rules for [" + sourceAddr + "/" + sourceAddrMask + "]");
        try {
            this.firewallAdmin.removeRuleForAllInterfaces(sourceAddr, sourceAddrMask, "tcp", TCP_PORT);
            this.firewallAdmin.removeRuleForAllInterfaces(sourceAddr, sourceAddrMask, "udp", UDP_PORT);
        }
        catch (FirewallAdminException fae) {
            Trace.trace(TRACE_MASKF, "Error removing FCS firewall rules");
            Trace.trace(TRACE_MASKF, fae);
        }
    }

    private void addRule(String sourceAddr, String sourceAddrMask) {
        Trace.trace(TRACE_MASKF, "<> adding FCS firewall rules for [" + sourceAddr + "/" + sourceAddrMask + "]");
        try {
            this.firewallAdmin.addRuleForAllInterfaces(sourceAddr, sourceAddrMask, "tcp", TCP_PORT);
            this.firewallAdmin.addRuleForAllInterfaces(sourceAddr, sourceAddrMask, "udp", UDP_PORT);
        }
        catch (FirewallAdminException fae) {
            Trace.trace(TRACE_MASKF, "Error adding FCS firewall rules");
            Trace.trace(TRACE_MASKF, fae);
        }
    }

    static {
        lock = new Object();
        subnetRulesLock = new Object();
        TCP_PORT = Integer.toString(9920);
        UDP_PORT = Integer.toString(9900);
    }
}

